/*
 * Decompiled with CFR 0.152.
 */
import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Properties;

public class InterfaceFactory {
    static Cp2110HidToUart cp2110_dll;
    static Ni4882 ni4882_dll;

    static boolean loadDlls() {
        Properties props = System.getProperties();
        props.setProperty("jna.library.path", "libs");
        try {
            cp2110_dll = new Cp2110HidToUart();
            ni4882_dll = new Ni4882();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    static String[] getRs232PortList() {
        SerialPort[] sports = SerialPort.getCommPorts();
        if (sports != null && sports.length > 0) {
            Object[] pnames = new String[sports.length];
            int i = 0;
            SerialPort[] serialPortArray = sports;
            int n = sports.length;
            int n2 = 0;
            while (n2 < n) {
                SerialPort port = serialPortArray[n2];
                pnames[i++] = port.getSystemPortName();
                ++n2;
            }
            Arrays.sort(pnames);
            return pnames;
        }
        return null;
    }

    static String[] getUsbDeviceList() {
        String[] devices = null;
        byte[] major = new byte[1];
        byte[] minor = new byte[1];
        int[] release = new int[1];
        int r = cp2110_dll.HidUart_GetLibraryVersion(major, minor, release);
        int[] num_devices = new int[]{99};
        r = cp2110_dll.HidUart_GetNumDevices(num_devices, (short)4292, (short)-30667);
        if (num_devices[0] > 0) {
            devices = new String[num_devices[0]];
            int d = 0;
            while (d < num_devices[0]) {
                String s;
                int i;
                byte[] sn = new byte[256];
                r = cp2110_dll.HidUart_GetString(d, (short)4292, (short)-30667, sn, 4);
                if (r == 0) {
                    i = 0;
                    while (i < sn.length && sn[i] != 0) {
                        ++i;
                    }
                } else {
                    devices = null;
                    break;
                }
                devices[d] = s = new String(sn, 0, i, StandardCharsets.UTF_8);
                ++d;
            }
        }
        return devices;
    }

    static short[] getGpibDeviceList(int board_id) {
        short[] devices = null;
        short[] instruments = new short[32];
        short[] result = new short[31];
        ni4882_dll.SendIFC(board_id);
        if ((ni4882_dll.ThreadIbsta() & Short.MIN_VALUE) != 0) {
            ni4882_dll.ibonl(board_id, 0);
            System.out.println("Unable to open board");
            return null;
        }
        int index = 0;
        int address = 1;
        while (index < 30) {
            instruments[index] = (short)address;
            ++index;
            ++address;
        }
        instruments[30] = -1;
        ni4882_dll.FindLstn(board_id, instruments, result, 31);
        if ((ni4882_dll.ThreadIbsta() & Short.MIN_VALUE) != 0) {
            ni4882_dll.ibonl(board_id, 0);
            System.out.println("Unable to issue FindLstn call");
            return null;
        }
        int num_listeners = ni4882_dll.ThreadIbcnt();
        devices = new short[num_listeners];
        int loop = 0;
        while (loop < num_listeners) {
            devices[loop] = result[loop];
            ++loop;
        }
        return devices;
    }

    static boolean haveGpib() {
        return ni4882_dll.ok();
    }

    static Interface getIo(physical_interface_t ct) {
        Interface r = null;
        switch (ct) {
            case physical_rs232: {
                r = new Rs232Interface();
                break;
            }
            case physical_ethernet: {
                r = new EthernetInterface();
                break;
            }
            case physical_gpib: {
                r = new GpibInterface(ni4882_dll);
                break;
            }
            case physical_usb: {
                r = new UsbInterface(cp2110_dll);
            }
        }
        return r;
    }

    public static enum physical_interface_t {
        physical_rs232,
        physical_ethernet,
        physical_gpib,
        physical_usb;

    }
}

