/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;

public class ImageTools {
    static byte[] fetch(String query) {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        byte[] i_data = sql.queryImage(query);
        return i_data;
    }

    static void fetchAndDraw(String query, Label dest) {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        byte[] i_data = sql.queryImage(query);
        if (i_data != null) {
            ByteArrayInputStream istream = new ByteArrayInputStream(i_data);
            ImageData imageData = new ImageData((InputStream)istream);
            Image ni = new Image((Device)Display.getDefault(), imageData);
            Rectangle lrect = dest.getBounds();
            int l_width = lrect.width - 5;
            int i_width = ni.getBounds().width;
            float xf = (float)l_width / (float)i_width;
            int l_height = lrect.height - 5;
            int i_height = ni.getBounds().height;
            float yf = (float)l_height / (float)i_height;
            if (xf < yf) {
                i_width = (int)(xf * (float)i_width);
                i_height = (int)(xf * (float)i_height);
            } else {
                i_width = (int)(yf * (float)i_width);
                i_height = (int)(yf * (float)i_height);
            }
            ImageData imgData = ni.getImageData();
            imgData = imgData.scaledTo(i_width, i_height);
            Image ni1 = new Image((Device)Display.getDefault(), imgData);
            dest.setImage(ni1);
        }
    }

    static void save(byte[] image, String table, String column, String cond) {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        sql.updateImage(table, column, cond, image);
    }

    static void loadDrawAndSave(String path, Label dest, String table, String column, String cond) {
        byte[] i_data = null;
        try {
            i_data = Files.readAllBytes(Paths.get(path, new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (i_data != null) {
            AnySql sql;
            int r;
            ByteArrayInputStream istream = new ByteArrayInputStream(i_data);
            ImageData imageData = new ImageData((InputStream)istream);
            Image ni = new Image((Device)Display.getDefault(), imageData);
            int i_width = ni.getBounds().width;
            int i_height = ni.getBounds().height;
            Rectangle lrect = dest.getBounds();
            int l_width = lrect.width - 5;
            float xf = (float)l_width / (float)i_width;
            int l_height = lrect.height - 5;
            float yf = (float)l_height / (float)i_height;
            if (xf < yf) {
                i_width = (int)(xf * (float)i_width);
                i_height = (int)(xf * (float)i_height);
            } else {
                i_width = (int)(yf * (float)i_width);
                i_height = (int)(yf * (float)i_height);
            }
            ImageData imgData = ni.getImageData();
            imgData = imgData.scaledTo(i_width, i_height);
            Image ni1 = new Image((Device)Display.getDefault(), imgData);
            dest.setImage(ni1);
            if (table != null && (r = (sql = new AnySql(UserSettings.sql_hostname)).updateImage(table, column, cond, i_data)) != 0) {
                MessageBox ed = new MessageBox(Display.getDefault().getActiveShell(), 33);
                ed.setText("Error");
                ed.setMessage("Cannot save image");
                ed.open();
            }
        } else {
            MessageBox ed = new MessageBox(Display.getDefault().getActiveShell(), 33);
            ed.setText("Error");
            ed.setMessage("Cannot read image");
            ed.open();
        }
    }

    static byte[] read(String path) {
        byte[] fc = null;
        try {
            fc = Files.readAllBytes(Paths.get(path, new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fc;
    }

    static void draw(Label dest, byte[] idata) {
        Rectangle lrect = dest.getBounds();
        ByteArrayInputStream istream = new ByteArrayInputStream(idata);
        ImageData imageData = new ImageData((InputStream)istream);
        Image i = new Image((Device)Display.getDefault(), imageData);
        int l_width = lrect.width - 5;
        int i_width = i.getBounds().width;
        float xf = (float)l_width / (float)i_width;
        int l_height = lrect.height - 5;
        int i_height = i.getBounds().height;
        float yf = (float)l_height / (float)i_height;
        if (xf < yf) {
            i_width = (int)(xf * (float)i_width);
            i_height = (int)(xf * (float)i_height);
        } else {
            i_width = (int)(yf * (float)i_width);
            i_height = (int)(yf * (float)i_height);
        }
        ImageData imgData = i.getImageData();
        imgData = imgData.scaledTo(i_width, i_height);
        Image ni1 = new Image((Device)Display.getDefault(), imgData);
        dest.setImage(ni1);
    }
}

