/*
 * Decompiled with CFR 0.152.
 */
import java.nio.charset.StandardCharsets;

public class GpibInterface
extends Interface {
    Ni4882 dll;
    int board;
    int dev;
    String last_error = "";

    public GpibInterface(Ni4882 dll) {
        this.dll = dll;
    }

    @Override
    public boolean isByteStream() {
        return false;
    }

    @Override
    public int open(String[] args) {
        int addr = Integer.parseInt(args[1]);
        int result = -1;
        short[] listen = new short[1];
        this.board = Integer.parseInt(args[0]);
        this.dll.SendIFC(this.board);
        if ((this.dll.ThreadIbsta() & Short.MIN_VALUE) != 0) {
            this.dll.ibonl(this.board, 0);
            System.out.println("Unable to open board 0");
            return -1;
        }
        int lr = this.dll.ibln(this.board, addr, 0, listen);
        if ((lr & Short.MIN_VALUE) != 0) {
            return -1;
        }
        if (listen[0] == 0) {
            return -1;
        }
        this.dev = this.dll.ibdev(this.board, addr, 0, 13, 1, 0);
        if ((this.dll.ThreadIbsta() & Short.MIN_VALUE) == 0) {
            this.dll.ibclr(this.dev);
            result = 0;
        } else {
            this.dll.ibonl(this.board, 0);
            this.last_error = "Unable to open device";
        }
        return result;
    }

    @Override
    public void close() {
        this.dll.ibonl(this.dev, 0);
    }

    public int read_stream(byte[] buffer, int max_to_read) {
        int ec;
        byte[] xfer = new byte[256];
        int len = 0;
        while ((ec = this.dll.ibrd(this.dev, xfer, 256)) == 0) {
            buffer[len] = xfer[0];
            if (++len < max_to_read) continue;
        }
        if (len > 0) {
            return len;
        }
        if ((ec & Short.MIN_VALUE) != 0) {
            this.last_error = "Read Error " + Integer.toHexString(ec);
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer, int max_to_read) {
        int len = 0;
        int ec = this.dll.ibrd(this.dev, buffer, max_to_read);
        if (ec != 0) {
            this.last_error = "Read Error " + Integer.toHexString(ec);
        }
        if ((len = this.dll.ThreadIbcnt()) > 0) {
            return len;
        }
        if ((ec & Short.MIN_VALUE) != 0) {
            this.last_error = "Read Error " + Integer.toHexString(ec);
        }
        return -1;
    }

    @Override
    public int write(byte[] buffer, int num_to_write) {
        int ws = 0;
        int[] rs = new int[]{this.dll.ibwrt(this.dev, buffer, num_to_write), this.dll.ThreadIbsta()};
        if ((rs[1] & Short.MIN_VALUE) != 0) {
            ws = -1;
            this.dll.ibonl(this.board, 0);
            this.last_error = "Unable to write";
        }
        return ws;
    }

    @Override
    public String strerror() {
        return this.last_error;
    }

    @Override
    int sendCommand(String cmd) {
        int ws = this.write(cmd.getBytes(), cmd.length());
        return ws;
    }

    @Override
    String getResponse(int max_length) {
        byte[] buffer = new byte[max_length];
        int r = this.read(buffer, max_length);
        if (r <= 2) {
            return null;
        }
        return new String(buffer, 0, r - 2, StandardCharsets.UTF_8);
    }
}

