/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class EthernetInterface
extends Interface {
    Socket socket;
    InputStream in_stream;
    OutputStream out_stream;

    @Override
    public int open(String[] args) {
        this.socket = new Socket();
        try {
            this.socket.connect(new InetSocketAddress(args[0], 10733), 250);
            this.socket.setSoTimeout(500);
            this.in_stream = this.socket.getInputStream();
            this.out_stream = this.socket.getOutputStream();
            return 0;
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public void close() {
        try {
            this.in_stream.close();
            this.out_stream.close();
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int read(byte[] buffer, int max_to_read) {
        try {
            int l = this.in_stream.read(buffer, 0, max_to_read);
            return l;
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public int write(byte[] buffer, int num_to_write) {
        int r = -1;
        try {
            this.out_stream.write(buffer, 0, num_to_write);
            this.out_stream.flush();
            r = 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return r;
    }

    @Override
    public String strerror() {
        return "Cannot connect";
    }
}

