/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class DutSettings_Edit {
    private static Text textDutModel;
    private static Table tableModelMap;
    private static Button btnAllowEnterStart;
    private static Button btnRequireModel;
    private static Button btnRequireSn;
    private static Label lblOfCharacters;
    private static Label lblSnLenHints;
    private static Button btnSelectModelField;
    private static Spinner spinnerNumOfSnLetters;
    private static Button btnDeleteModel;
    private static Text textNewModel;
    private static Label lblModelAddHint;
    private static String sequenceName;

    public static Composite editor(final Composite parent, DutSettings settings, String sequence_name) {
        Composite edit_widgets = new Composite(parent, 0);
        edit_widgets.setBackground(SWTResourceManager.getColor(192, 192, 192));
        sequenceName = sequence_name;
        Group groupModelNum = new Group(edit_widgets, 0);
        groupModelNum.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        groupModelNum.setText("Model #");
        groupModelNum.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupModelNum.setBackground(SWTResourceManager.getColor(192, 192, 192));
        groupModelNum.setBounds(10, 0, 390, 156);
        textDutModel = new Text((Composite)groupModelNum, 2048);
        textDutModel.setBounds(10, 29, 221, 27);
        textDutModel.setToolTipText("Sets the initial model # which will appear when the sequence first loads and will appear in the formatted reports.");
        textDutModel.setText(settings.model);
        Label lblModelHint = new Label((Composite)groupModelNum, 0);
        lblModelHint.setBounds(10, 62, 370, 51);
        lblModelHint.setText("Sets the initial model # which will appear when the sequence\r\nfirst loads and will appear in the formatted reports. Use this\r\nwhen the sequence is dedicated to a single model.");
        btnRequireModel = new Button((Composite)groupModelNum, 32);
        btnRequireModel.setBounds(10, 119, 152, 16);
        btnRequireModel.setSelection(settings.require_model);
        btnRequireModel.setToolTipText("Requires a model string to run the test.");
        btnRequireModel.setText("Require Model To Run");
        Group grpDutNumbering = new Group(edit_widgets, 0);
        grpDutNumbering.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpDutNumbering.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpDutNumbering.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpDutNumbering.setText("DUT Serial Numbering");
        grpDutNumbering.setBounds(10, 173, 390, 225);
        btnAllowEnterStart = new Button((Composite)grpDutNumbering, 32);
        btnAllowEnterStart.setToolTipText("Allows <Enter> in the serrial number field to start the test.");
        btnAllowEnterStart.setBounds(10, 30, 283, 16);
        btnAllowEnterStart.setText("Typing <Enter> in the serial # field starts the test");
        btnAllowEnterStart.setSelection(settings.serial_number_enter_starts);
        btnRequireSn = new Button((Composite)grpDutNumbering, 32);
        btnRequireSn.setBounds(10, 78, 152, 16);
        btnRequireSn.setSelection(settings.require_serial_number);
        btnRequireSn.setToolTipText("Requires a serial number to run the test.");
        btnRequireSn.setText("Require Serial # To Run");
        btnRequireSn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnRequireSn.getSelection()) {
                    lblOfCharacters.setVisible(true);
                    lblSnLenHints.setVisible(true);
                    spinnerNumOfSnLetters.setVisible(true);
                } else {
                    lblOfCharacters.setVisible(false);
                    lblSnLenHints.setVisible(false);
                    spinnerNumOfSnLetters.setVisible(false);
                }
            }
        });
        lblOfCharacters = new Label((Composite)grpDutNumbering, 0);
        lblOfCharacters.setBounds(170, 79, 82, 15);
        lblOfCharacters.setText("# Of Characters");
        spinnerNumOfSnLetters = new Spinner((Composite)grpDutNumbering, 2048);
        spinnerNumOfSnLetters.setMaximum(99);
        spinnerNumOfSnLetters.setMinimum(0);
        spinnerNumOfSnLetters.setSelection(settings.serial_number_length);
        spinnerNumOfSnLetters.setBounds(258, 76, 35, 22);
        lblSnLenHints = new Label((Composite)grpDutNumbering, 0);
        lblSnLenHints.setBounds(27, 100, 353, 38);
        lblSnLenHints.setText("When the number of characters is zero any length greater than 1 is\r\nacceptable; otherwise the exact length must be entered.");
        btnSelectModelField = new Button((Composite)grpDutNumbering, 32);
        btnSelectModelField.setBounds(10, 144, 250, 16);
        btnSelectModelField.setSelection(settings.select_model_after_test);
        btnSelectModelField.setToolTipText("Check when using test automation to load model specific sequences.");
        btnSelectModelField.setText("Select model field after the test completes");
        Label lblCheckThisWhen = new Label((Composite)grpDutNumbering, 0);
        lblCheckThisWhen.setText("Check this when using full automation workflow to select the\r\na model number field after the test completes.");
        lblCheckThisWhen.setBounds(27, 166, 353, 38);
        if (!settings.require_serial_number) {
            lblOfCharacters.setVisible(false);
            spinnerNumOfSnLetters.setVisible(false);
            lblSnLenHints.setVisible(false);
        }
        Group grpModelMap = new Group(edit_widgets, 0);
        grpModelMap.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpModelMap.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpModelMap.setText("Model Mapping");
        grpModelMap.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpModelMap.setBounds(413, 0, 332, 398);
        tableModelMap = new Table((Composite)grpModelMap, 68112);
        tableModelMap.setBounds(205, 35, 110, 279);
        tableModelMap.setHeaderVisible(true);
        tableModelMap.setLinesVisible(true);
        tableModelMap.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int ri = tableModelMap.getSelectionIndex();
                if (ri != -1) {
                    btnDeleteModel.setVisible(true);
                }
            }
        });
        TableColumn tblclmnModelName = new TableColumn(tableModelMap, 0);
        tblclmnModelName.setWidth(110);
        tblclmnModelName.setText("Model Names");
        for (String mn : settings.model_map) {
            TableItem n_item = new TableItem(tableModelMap, 0);
            n_item.setText(mn);
        }
        textNewModel = new Text((Composite)grpModelMap, 2048);
        textNewModel.setBounds(10, 86, 123, 25);
        textNewModel.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                String m;
                btnDeleteModel.setVisible(false);
                e.doit = false;
                int k = e.stateMask + e.keyCode;
                if (k == 13 && !(m = textNewModel.getText()).isEmpty()) {
                    TableItem[] mitems;
                    boolean found = false;
                    TableItem[] tableItemArray = mitems = tableModelMap.getItems();
                    int n = mitems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem i = tableItemArray[n2];
                        if (m.equals(i.getText())) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (found) {
                        MessageBox mil = new MessageBox(parent.getShell(), 40);
                        mil.setText("Information");
                        mil.setMessage("That model is already mapped.");
                        mil.open();
                    } else {
                        String s = DutSettings.modelToSequence(m);
                        boolean do_add = true;
                        if (s != null && !sequenceName.equals(s)) {
                            MessageBox mas = new MessageBox(parent.getShell(), 200);
                            mas.setText("Information");
                            mas.setMessage("That model is mapped to '" + s + "'.\n\nClick on Yes to remap the model.");
                            int r = mas.open();
                            if (r == 128) {
                                do_add = false;
                            }
                        }
                        if (do_add) {
                            TableItem n_item = new TableItem(tableModelMap, 0);
                            n_item.setText(m);
                        }
                        textNewModel.setText("");
                    }
                }
            }
        });
        textNewModel.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                btnDeleteModel.setVisible(false);
            }
        });
        btnDeleteModel = new Button((Composite)grpModelMap, 0);
        btnDeleteModel.setToolTipText("Deletes the selected model.");
        btnDeleteModel.setBounds(138, 152, 61, 25);
        btnDeleteModel.setText("Delete");
        btnDeleteModel.setVisible(false);
        btnDeleteModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int ri = tableModelMap.getSelectionIndex();
                if (ri != -1) {
                    tableModelMap.remove(ri);
                }
                btnDeleteModel.setVisible(false);
            }
        });
        Label lblModelMapHint = new Label((Composite)grpModelMap, 0);
        lblModelMapHint.setBounds(10, 332, 295, 30);
        lblModelMapHint.setText("When running tests these model names automatically\r\nload this sequence.");
        lblModelAddHint = new Label((Composite)grpModelMap, 0);
        lblModelAddHint.setText("Enter new model names below and\r\npress <ENTER> to add.\r\n");
        lblModelAddHint.setBounds(10, 39, 189, 30);
        return edit_widgets;
    }

    public static void fetch(DutSettings settings) {
        TableItem[] mitems;
        settings.model = textDutModel.getText();
        settings.serial_number_enter_starts = btnAllowEnterStart.getSelection();
        settings.require_model = btnRequireModel.getSelection();
        settings.require_serial_number = btnRequireSn.getSelection();
        settings.select_model_after_test = btnSelectModelField.getSelection();
        settings.serial_number_length = spinnerNumOfSnLetters.getSelection();
        settings.model_map.clear();
        TableItem[] tableItemArray = mitems = tableModelMap.getItems();
        int n = mitems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem i = tableItemArray[n2];
            settings.model_map.add(i.getText());
            ++n2;
        }
    }
}

