/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class ConfigurationEditSwitch
extends Dialog {
    protected Shell shl_edit;
    String[] serial_ports;
    String model_name;
    int switch_num;
    InterfaceFactory.physical_interface_t iface;
    String[] init_settings;
    private Button btnRS232;
    private Button btnEthernet;
    private Button btnGpib;
    private Combo combo_com_ports;
    private Combo combo_baud_rate;
    private Text ip_address;
    private Label lbl_gpib_controller;
    private Label lbl_gpib_address;
    private Spinner spinner_gpib_controller;
    private Spinner spinner_gpib_address;
    private Label lblInterfaceErrorText;
    private Label lblVerifyPassedIcon;
    private Label lblVerifyFailedIcon;
    private Thread com_worker;
    private Interface comm_io;
    int exit_code;
    private Button btnDelete;

    public ConfigurationEditSwitch(Shell parent, String[] sports, String model, int num, InterfaceFactory.physical_interface_t pi, String[] settings) {
        super(parent, 67616);
        this.serial_ports = sports;
        this.model_name = model;
        this.switch_num = num;
        this.iface = pi;
        this.init_settings = settings;
        this.setText("SWT Dialog");
    }

    public int open() {
        this.createContents();
        this.exit_code = -1;
        this.shl_edit.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\u001b') {
                    event.doit = false;
                }
            }
        });
        this.shl_edit.open();
        this.shl_edit.layout();
        Display display = this.getParent().getDisplay();
        while (this.exit_code == -1) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.exit_code;
    }

    public void close() {
        this.shl_edit.dispose();
    }

    private void createContents() {
        this.shl_edit = new Shell(this.getParent(), this.getStyle());
        this.shl_edit.setSize(344, 282);
        this.shl_edit.setText("Switch Connection Settings");
        Display d = Display.getDefault();
        Point loc = d.getActiveShell().getLocation();
        this.shl_edit.setLocation(loc.x + 100, loc.y + 100);
        Label lblSwitchId = new Label((Composite)this.shl_edit, 0);
        lblSwitchId.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        lblSwitchId.setBounds(102, 10, 123, 19);
        lblSwitchId.setText("Switch #" + this.switch_num);
        this.btnRS232 = new Button((Composite)this.shl_edit, 16);
        this.btnRS232.setBounds(20, 35, 90, 16);
        this.btnRS232.setText("RS232");
        this.btnRS232.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    ConfigurationEditSwitch.this.iface = InterfaceFactory.physical_interface_t.physical_rs232;
                    ConfigurationEditSwitch.this.combo_com_ports.setVisible(true);
                    ConfigurationEditSwitch.this.combo_baud_rate.setVisible(true);
                    ConfigurationEditSwitch.this.ip_address.setVisible(false);
                    ConfigurationEditSwitch.this.lbl_gpib_controller.setVisible(false);
                    ConfigurationEditSwitch.this.lbl_gpib_address.setVisible(false);
                    ConfigurationEditSwitch.this.spinner_gpib_controller.setVisible(false);
                    ConfigurationEditSwitch.this.spinner_gpib_address.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnGpib = new Button((Composite)this.shl_edit, 16);
        this.btnGpib.setBounds(20, 60, 47, 16);
        this.btnGpib.setText("GPIB");
        this.btnGpib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    ConfigurationEditSwitch.this.iface = InterfaceFactory.physical_interface_t.physical_gpib;
                    ConfigurationEditSwitch.this.combo_com_ports.setVisible(false);
                    ConfigurationEditSwitch.this.combo_baud_rate.setVisible(false);
                    ConfigurationEditSwitch.this.ip_address.setVisible(false);
                    ConfigurationEditSwitch.this.lbl_gpib_controller.setVisible(true);
                    ConfigurationEditSwitch.this.lbl_gpib_address.setVisible(true);
                    ConfigurationEditSwitch.this.spinner_gpib_controller.setVisible(true);
                    ConfigurationEditSwitch.this.spinner_gpib_address.setVisible(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnEthernet = new Button((Composite)this.shl_edit, 16);
        this.btnEthernet.setBounds(20, 85, 90, 16);
        this.btnEthernet.setText("Ethernet");
        this.btnEthernet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    ConfigurationEditSwitch.this.iface = InterfaceFactory.physical_interface_t.physical_ethernet;
                    ConfigurationEditSwitch.this.combo_com_ports.setVisible(false);
                    ConfigurationEditSwitch.this.combo_baud_rate.setVisible(false);
                    ConfigurationEditSwitch.this.ip_address.setVisible(true);
                    ConfigurationEditSwitch.this.lbl_gpib_controller.setVisible(false);
                    ConfigurationEditSwitch.this.lbl_gpib_address.setVisible(false);
                    ConfigurationEditSwitch.this.spinner_gpib_controller.setVisible(false);
                    ConfigurationEditSwitch.this.spinner_gpib_address.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.combo_com_ports = new Combo((Composite)this.shl_edit, 8);
        this.combo_com_ports.setBounds(117, 35, 91, 23);
        if (this.serial_ports != null) {
            this.combo_com_ports.setItems(this.serial_ports);
        }
        this.combo_baud_rate = new Combo((Composite)this.shl_edit, 0);
        this.combo_baud_rate.setItems(new String[]{"9600", "19200", "57600", "115200"});
        this.combo_baud_rate.setBounds(220, 35, 91, 23);
        this.combo_baud_rate.setText("115200");
        this.lbl_gpib_controller = new Label((Composite)this.shl_edit, 0);
        this.lbl_gpib_controller.setVisible(false);
        this.lbl_gpib_controller.setBounds(96, 62, 59, 15);
        this.lbl_gpib_controller.setText("Controller");
        this.spinner_gpib_controller = new Spinner((Composite)this.shl_edit, 2048);
        this.spinner_gpib_controller.setVisible(false);
        this.spinner_gpib_controller.setMaximum(7);
        this.spinner_gpib_controller.setMinimum(0);
        this.spinner_gpib_controller.setBounds(159, 60, 47, 22);
        this.lbl_gpib_address = new Label((Composite)this.shl_edit, 0);
        this.lbl_gpib_address.setVisible(false);
        this.lbl_gpib_address.setBounds(217, 62, 47, 15);
        this.lbl_gpib_address.setText("Address");
        this.spinner_gpib_address = new Spinner((Composite)this.shl_edit, 2048);
        this.spinner_gpib_address.setVisible(true);
        this.spinner_gpib_address.setMaximum(32);
        this.spinner_gpib_address.setMinimum(1);
        this.spinner_gpib_address.setBounds(270, 60, 41, 22);
        this.ip_address = new Text((Composite)this.shl_edit, 2048);
        this.ip_address.setVisible(true);
        this.ip_address.setBounds(117, 85, 91, 21);
        this.ip_address.setText("192.168.1.100");
        this.btnRS232.setSelection(false);
        this.btnEthernet.setSelection(false);
        this.btnGpib.setSelection(false);
        this.combo_com_ports.setVisible(false);
        this.combo_baud_rate.setVisible(false);
        this.ip_address.setVisible(false);
        this.lbl_gpib_controller.setVisible(false);
        this.lbl_gpib_address.setVisible(false);
        this.spinner_gpib_controller.setVisible(false);
        this.spinner_gpib_address.setVisible(false);
        this.combo_com_ports.setText(this.serial_ports[0]);
        this.combo_baud_rate.setText("115200");
        this.ip_address.setText("192.168.1.100");
        this.spinner_gpib_controller.setSelection(0);
        this.spinner_gpib_address.setSelection(1);
        if (!this.model_name.equals("M10x")) {
            this.btnEthernet.setVisible(false);
        }
        switch (this.iface) {
            case physical_rs232: {
                this.combo_com_ports.setText(this.init_settings[0]);
                this.combo_baud_rate.setText(this.init_settings[1]);
                this.btnRS232.setSelection(true);
                this.combo_com_ports.setVisible(true);
                this.combo_baud_rate.setVisible(true);
                break;
            }
            case physical_ethernet: {
                this.ip_address.setText(this.init_settings[0]);
                this.btnEthernet.setSelection(true);
                this.ip_address.setVisible(true);
                break;
            }
            case physical_gpib: {
                this.spinner_gpib_address.setSelection(Integer.valueOf(this.init_settings[0]).intValue());
                this.spinner_gpib_address.setSelection(Integer.valueOf(this.init_settings[1]).intValue());
                this.btnGpib.setSelection(true);
                this.lbl_gpib_controller.setVisible(true);
                this.lbl_gpib_address.setVisible(true);
                this.spinner_gpib_controller.setVisible(true);
                this.spinner_gpib_address.setVisible(true);
                break;
            }
        }
        this.btnDelete = new Button((Composite)this.shl_edit, 0);
        this.btnDelete.setBounds(20, 118, 75, 25);
        this.btnDelete.setForeground(SWTResourceManager.getColor(255, 0, 0));
        this.btnDelete.setText("Delete");
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationEditSwitch.this.exit_code = 127;
            }
        });
        Button btnOk = new Button((Composite)this.shl_edit, 0);
        btnOk.setBounds(135, 118, 75, 25);
        btnOk.setText("OK");
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationEditSwitch.this.exit_code = 32;
            }
        });
        Button btnCancel = new Button((Composite)this.shl_edit, 0);
        btnCancel.setBounds(242, 118, 75, 25);
        btnCancel.setText("Cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationEditSwitch.this.exit_code = 256;
            }
        });
        this.lblVerifyPassedIcon = new Label((Composite)this.shl_edit, 0);
        this.lblVerifyPassedIcon.setImage(SWTResourceManager.getImage("images/ok_pass.png"));
        this.lblVerifyPassedIcon.setBounds(100, 159, 50, 50);
        this.lblVerifyPassedIcon.setVisible(false);
        this.lblVerifyFailedIcon = new Label((Composite)this.shl_edit, 0);
        this.lblVerifyFailedIcon.setImage(SWTResourceManager.getImage("images/error_fail.png"));
        this.lblVerifyFailedIcon.setBounds(100, 159, 50, 50);
        this.lblVerifyFailedIcon.setVisible(false);
        this.lblInterfaceErrorText = new Label((Composite)this.shl_edit, 0);
        this.lblInterfaceErrorText.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.lblInterfaceErrorText.setForeground(SWTResourceManager.getColor(255, 0, 0));
        this.lblInterfaceErrorText.setBounds(160, 173, 163, 19);
        this.lblInterfaceErrorText.setText("Model:964i SN:26024");
        this.lblInterfaceErrorText.setVisible(false);
        Button btnVerify = new Button((Composite)this.shl_edit, 0);
        btnVerify.setBounds(20, 170, 75, 25);
        btnVerify.setText("Verify");
        btnVerify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationEditSwitch.this.lblVerifyPassedIcon.setVisible(false);
                ConfigurationEditSwitch.this.lblVerifyFailedIcon.setVisible(false);
                ConfigurationEditSwitch.this.lblInterfaceErrorText.setVisible(false);
                final String[] comm_args = new String[2];
                switch (ConfigurationEditSwitch.this.iface) {
                    case physical_rs232: {
                        comm_args[0] = ConfigurationEditSwitch.this.combo_com_ports.getText();
                        comm_args[1] = ConfigurationEditSwitch.this.combo_baud_rate.getText();
                        break;
                    }
                    case physical_ethernet: {
                        comm_args[0] = ConfigurationEditSwitch.this.ip_address.getText();
                        break;
                    }
                    case physical_gpib: {
                        comm_args[0] = ConfigurationEditSwitch.this.spinner_gpib_controller.getText();
                        comm_args[1] = ConfigurationEditSwitch.this.spinner_gpib_address.getText();
                        break;
                    }
                }
                ConfigurationEditSwitch.this.com_worker = new Thread(){

                    @Override
                    public void run() {
                        ConfigurationEditSwitch.this.comm_io = InterfaceFactory.getIo((this).ConfigurationEditSwitch.this.iface);
                        if (ConfigurationEditSwitch.this.comm_io.open(comm_args) == 0) {
                            ConfigurationEditSwitch.this.comm_io.sendCommand("*idn?");
                            final String reply = ConfigurationEditSwitch.this.comm_io.getResponse(100);
                            ConfigurationEditSwitch.this.comm_io.close();
                            ConfigurationEditSwitch.this.getParent().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (reply != null) {
                                        String[] f = reply.split(",");
                                        if (f.length >= 3) {
                                            String d = "Model:" + f[1] + " SN:" + f[2];
                                            ConfigurationEditSwitch.this.lblVerifyPassedIcon.setVisible(true);
                                            ConfigurationEditSwitch.this.lblInterfaceErrorText.setForeground(SWTResourceManager.getColor(0, 0, 0));
                                            ConfigurationEditSwitch.this.lblInterfaceErrorText.setText(d);
                                            ConfigurationEditSwitch.this.lblInterfaceErrorText.setVisible(true);
                                        } else {
                                            ConfigurationEditSwitch.this.lblVerifyFailedIcon.setVisible(true);
                                            ConfigurationEditSwitch.this.lblInterfaceErrorText.setText("Reply:" + reply);
                                            ConfigurationEditSwitch.this.lblInterfaceErrorText.setForeground(SWTResourceManager.getColor(255, 0, 0));
                                        }
                                    } else {
                                        ConfigurationEditSwitch.this.lblVerifyFailedIcon.setVisible(true);
                                    }
                                }
                            });
                        } else {
                            ConfigurationEditSwitch.this.getParent().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ConfigurationEditSwitch.this.lblInterfaceErrorText.setText(ConfigurationEditSwitch.this.comm_io.strerror());
                                    ConfigurationEditSwitch.this.lblInterfaceErrorText.setForeground(SWTResourceManager.getColor(255, 0, 0));
                                    ConfigurationEditSwitch.this.lblInterfaceErrorText.setVisible(true);
                                    ConfigurationEditSwitch.this.lblVerifyFailedIcon.setVisible(true);
                                }
                            });
                        }
                    }
                };
                ConfigurationEditSwitch.this.com_worker.start();
            }
        });
    }

    public InterfaceFactory.physical_interface_t getInterface() {
        return this.iface;
    }

    public String[] getSettings() {
        String[] s = new String[]{"", ""};
        switch (this.iface) {
            case physical_rs232: {
                s[0] = this.combo_com_ports.getText();
                s[1] = this.combo_baud_rate.getText();
                break;
            }
            case physical_ethernet: {
                s[0] = this.ip_address.getText();
                break;
            }
            case physical_gpib: {
                s[0] = this.spinner_gpib_controller.getText();
                s[1] = this.spinner_gpib_address.getText();
                break;
            }
        }
        return s;
    }
}

