/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class AnySql {
    static final int ANYSQL_IS_LITE = 1;
    static final int ANYSQL_IS_MARIADB = 2;
    static String SqliteDbPath = "";
    static int DbType = 0;
    String hostname;
    Connection conn;

    public AnySql(String host) {
        this.hostname = host;
        this.conn = null;
        if (DbType == 0) {
            AnySql.dbType();
        }
    }

    public int open() {
        int r = -1;
        if (DbType == 2) {
            try {
                String myUrl = this.hostname == "" ? "jdbc:mariadb://localhost:3306/vitrek" : "jdbc:mariadb://" + this.hostname + ":3306/vitrek";
                DriverManager.setLoginTimeout(5);
                this.conn = DriverManager.getConnection(myUrl, "ultra", "unDerTake4");
                r = 0;
            }
            catch (Exception e) {
                System.err.println("Cannot open DB!");
                System.err.println(e.getMessage());
                r = -1;
            }
        } else {
            try {
                String url = "jdbc:sqlite:" + SqliteDbPath;
                this.conn = DriverManager.getConnection(url);
                r = 0;
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
        }
        return r;
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.conn = null;
    }

    public String[] queryColumn(String query) {
        boolean need_close = false;
        ArrayList<String> qdata = new ArrayList<String>();
        if (this.conn == null) {
            need_close = false;
            this.open();
        }
        try {
            Statement st = this.conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            boolean rsr = rs.next();
            if (rsr) {
                do {
                    String s = rs.getObject(1, String.class);
                    qdata.add(s);
                } while (rs.next());
            }
            rs.close();
            st.close();
        }
        catch (SQLException st) {
            // empty catch block
        }
        if (need_close) {
            this.close();
        }
        String[] results = new String[qdata.size()];
        results = qdata.toArray(results);
        return results;
    }

    public String[] queryRow(String query) {
        boolean need_close = false;
        String[] results = null;
        if (this.conn == null) {
            need_close = false;
            this.open();
        }
        try {
            Statement st = this.conn.createStatement();
            ResultSet rs = st.executeQuery(String.valueOf(query) + " limit 1");
            boolean rsr = rs.next();
            if (rsr) {
                ResultSetMetaData md = rs.getMetaData();
                results = new String[md.getColumnCount()];
                int i = 0;
                while (i < md.getColumnCount()) {
                    results[i] = rs.getObject(i + 1, String.class);
                    ++i;
                }
            }
            rs.close();
            st.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (need_close) {
            this.close();
        }
        return results;
    }

    public ArrayList<String[]> queryRows(String query) {
        boolean need_close = false;
        ArrayList<String[]> qdata = new ArrayList<String[]>();
        if (this.conn == null) {
            need_close = false;
            this.open();
        }
        try {
            Statement st = this.conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            boolean rsr = rs.next();
            if (rsr) {
                ResultSetMetaData md = rs.getMetaData();
                do {
                    String[] s = new String[md.getColumnCount()];
                    int i = 0;
                    while (i < md.getColumnCount()) {
                        s[i] = rs.getObject(i + 1, String.class);
                        ++i;
                    }
                    qdata.add(s);
                } while (rs.next());
            }
            rs.close();
            st.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (need_close) {
            this.close();
        }
        return qdata;
    }

    public int execute(String command) {
        boolean need_close = false;
        int r = -1;
        if (this.conn == null) {
            need_close = false;
            this.open();
        }
        try {
            Statement st = this.conn.createStatement();
            int sr = st.executeUpdate(command);
            if (sr == 1) {
                r = 0;
            }
        }
        catch (SQLException e) {
            r = -1;
        }
        if (need_close) {
            this.close();
        }
        return r;
    }

    public int insertWithId(String command) {
        boolean need_close = false;
        int id = -1;
        if (this.conn == null) {
            need_close = false;
            this.open();
        }
        try {
            Statement st = this.conn.createStatement();
            int sr = st.executeUpdate(command);
            if (sr == 1) {
                String[] liid = DbType == 2 ? this.queryRow("select LAST_INSERT_ID()") : this.queryRow("select last_insert_rowid()");
                id = liid != null ? Integer.valueOf(liid[0]) : -1;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            id = -1;
        }
        if (need_close) {
            this.close();
        }
        return id;
    }

    public byte[] queryImage(String query) {
        boolean need_close = false;
        byte[] idata = null;
        if (this.conn == null) {
            need_close = false;
            this.open();
        }
        try {
            Statement st = this.conn.createStatement();
            ResultSet rs = st.executeQuery(String.valueOf(query) + " limit 1");
            boolean rsr = rs.next();
            if (rsr) {
                idata = rs.getBytes(1);
            }
            rs.close();
            st.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (need_close) {
            this.close();
        }
        return idata;
    }

    public int updateImage(String table, String column, String cond, byte[] image_data) {
        boolean need_close = false;
        int r = -1;
        if (this.conn == null) {
            need_close = false;
            this.open();
        }
        try {
            String cmd = "UPDATE " + table + " SET " + column + "=? WHERE " + cond;
            PreparedStatement st = this.conn.prepareStatement(cmd);
            st.setBytes(1, image_data);
            int sr = st.executeUpdate();
            if (sr == 1) {
                r = 0;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            r = -1;
        }
        if (need_close) {
            this.close();
        }
        return r;
    }

    static int dbType() {
        String db_ini = "db_path.ini";
        if (DbType == 0) {
            DbType = 2;
            File file = new File(db_ini);
            if (file.exists()) {
                String path = "";
                try {
                    path = new String(Files.readAllBytes(Paths.get(db_ini, new String[0])));
                    path.replaceAll("\\R", "");
                    SqliteDbPath = path;
                    DbType = 1;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return DbType;
    }

    public static int probe(String host) {
        int r = -1;
        try {
            String myUrl = host == "" ? "jdbc:mariadb://localhost:3306/vitrek" : "jdbc:mariadb://" + host + ":3306/vitrek";
            DriverManager.setLoginTimeout(5);
            Connection conn = DriverManager.getConnection(myUrl, "ultra", "unDerTake4");
            String query = "SELECT count(*) FROM access_levels";
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            r = 0;
            if (rs.next()) {
                r = rs.getInt("count(*)");
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            System.err.println("Probe failed!");
            System.err.println(e.getMessage());
            r = -1;
        }
        return r;
    }
}

